' Check tool rework status and tool type directly from SAP ZMEC transaction
On Error Resume Next

' Initialize FileSystemObject
Dim fso, logFile, logPath
Set fso = CreateObject("Scripting.FileSystemObject")
If Err.Number <> 0 Then
    WScript.Echo "ERROR: Failed to create FileSystemObject - " & Err.Description
    WScript.Quit 1
End If

' Get temp folder path and create log path
logPath = fso.GetSpecialFolder(2) & "\sap_rework_and_tool_type_check.log"
WScript.Echo "DEBUG: Log path will be: " & logPath

' Initialize log file if path is provided
If WScript.Arguments.Count > 1 Then
    logPath = WScript.Arguments.Item(1)
    On Error Resume Next
    Set logFile = fso.OpenTextFile(logPath, 8, True)
    If Err.Number <> 0 Then
        WScript.Echo "ERROR: Could not open log file: " & Err.Description
        Err.Clear
        Set logFile = Nothing
    Else        ' Log script start
        LogMessage "========================================="
        LogMessage "Rework and Tool Type Check Script Started at " & Now
        LogMessage "Script: " & WScript.ScriptName
        LogMessage "Material Number: " & WScript.Arguments.Item(0)
        LogMessage "========================================="
    End If
End If

' Try to open or create the log file
On Error Resume Next
Set logFile = fso.OpenTextFile(logPath, 8, True)
If Err.Number <> 0 Then
    WScript.Echo "ERROR: Failed to open log file - " & Err.Description
    WScript.Echo "Attempting to create new log file..."
    
    ' Try to create a new file
    On Error Resume Next
    Set logFile = fso.CreateTextFile(logPath, True)
    If Err.Number <> 0 Then
        WScript.Echo "ERROR: Failed to create log file - " & Err.Description
        WScript.Quit 1
    End If
End If

' Define logging function
Sub LogMessage(message)
    On Error Resume Next
    If Not logFile Is Nothing Then
        logFile.WriteLine Now & " - [" & WScript.ScriptName & "] - " & message
        If Err.Number <> 0 Then
            WScript.Echo "ERROR: Failed to write to log - " & Err.Description
        End If
    End If
    ' Echo to console for immediate feedback
    WScript.Echo message
End Sub

' Define function to close log file
Sub CloseLogFile()
    On Error Resume Next
    If Not logFile Is Nothing Then
        logFile.Close
        Set logFile = Nothing
    End If
    On Error Goto 0
End Sub

' Test logging
LogMessage "=== Rework and Tool Type Check Started ==="
LogMessage "Log file initialized at: " & logPath

LogMessage "Checking material number: " & WScript.Arguments.Item(0)

' Set scripting mode to true
Set WSHShell = CreateObject("WScript.Shell")

' Disable SAP GUI scripting warnings in registry
On Error Resume Next
WSHShell.RegWrite "HKEY_CURRENT_USER\Software\SAP\SAPGUI Front\SAP Frontend Server\Security\WarnOnAttach", 0, "REG_DWORD"
WSHShell.RegWrite "HKEY_CURRENT_USER\Software\SAP\SAPGUI Front\SAP Frontend Server\Security\WarnOnConnection", 0, "REG_DWORD"
If Err.Number <> 0 Then
    LogMessage "Error setting registry keys: " & Err.Description
    Err.Clear
End If

' Get material number from command line
materialNumber = WScript.Arguments.Item(0)
LogMessage "Material number received: " & materialNumber

' Initialize SAP connection
On Error Resume Next
If Not IsObject(application) Then
   Set SapGuiAuto = GetObject("SAPGUI")
   If Err.Number <> 0 Then
       LogMessage "Error getting SAPGUI: " & Err.Description
       WScript.Echo "ERROR: Cannot connect to SAP - " & Err.Description
       WScript.Quit 1
   End If
   Set application = SapGuiAuto.GetScriptingEngine
   If Err.Number <> 0 Then
       LogMessage "Error getting scripting engine: " & Err.Description
       WScript.Echo "ERROR: Cannot initialize SAP scripting - " & Err.Description
       WScript.Quit 1
   End If
End If

LogMessage "SAP GUI initialized successfully"

If Not IsObject(connection) Then
   Set connection = application.Children(0)
   If Err.Number <> 0 Then
       LogMessage "Error getting connection: " & Err.Description
       WScript.Echo "ERROR: No SAP connection available - " & Err.Description
       WScript.Quit 1
   End If
End If

If Not IsObject(session) Then
   Set session = connection.Children(0)
   If Err.Number <> 0 Then
       LogMessage "Error getting session: " & Err.Description
       WScript.Echo "ERROR: No SAP session available - " & Err.Description
       WScript.Quit 1
   End If
End If

' Execute SAP commands
On Error Resume Next
LogMessage "Executing SAP commands..."

session.findById("wnd[0]").maximize
LogMessage "Window maximized"

session.findById("wnd[0]/tbar[0]/okcd").text = "zmec"
LogMessage "Entered transaction code: zmec"

session.findById("wnd[0]").sendVKey 0
LogMessage "Executed transaction"

session.findById("wnd[0]/usr/ctxtP_MATNR").text = materialNumber
LogMessage "Entered material number: " & materialNumber

session.findById("wnd[0]/usr/ctxtP_WERKS").text = "nl01"
session.findById("wnd[0]/usr/ctxtP_VKORG").text = "nl01"
LogMessage "Set plant and sales org to nl01"

session.findById("wnd[0]").sendVKey 8
LogMessage "Executed search"

session.findById("wnd[0]/usr/lbl[138,5]").setFocus
If Err.Number <> 0 Then
    LogMessage "Error accessing rework status field: " & Err.Description
    WScript.Echo "ERROR: Cannot access rework status - " & Err.Description
    WScript.Quit 1
End If

' Get the rework status at the focused position
reworkStatus = session.findById("wnd[0]/usr/lbl[138,5]").text
LogMessage "Retrieved rework status: " & reworkStatus

' Also get the tool type from the same screen
On Error Resume Next
toolType = session.findById("wnd[0]/usr/lbl[131,5]").text
If Err.Number <> 0 Then
    LogMessage "Error accessing tool type field: " & Err.Description
    toolType = "UNKNOWN"
Else
    LogMessage "Retrieved tool type: " & toolType
End If
On Error Resume Next

' Check if status is U3
If Trim(reworkStatus) = "U3" Then
    LogMessage "Status is U3 - needs rework"
    WScript.Echo "needs-rework"
Else
    LogMessage "Status is not U3 - no rework needed"
    WScript.Echo "no-rework"
End If

' Output tool type information
LogMessage "Tool type check result: " & Trim(toolType)
If Trim(toolType) = "Z007" Then
    LogMessage "Tool type is Z007 - Tool"
    WScript.Echo "TOOL_TYPE:tool"
ElseIf Trim(toolType) = "Z004" Then
    LogMessage "Tool type is Z004 - Consumable"
    WScript.Echo "TOOL_TYPE:consumable"
Else
    LogMessage "Tool type is unknown or other: " & toolType
    WScript.Echo "TOOL_TYPE:unknown-type"
End If

' Close transaction
session.findById("wnd[0]").sendVKey 2
session.findById("wnd[0]").sendVKey 12
session.findById("wnd[0]").sendVKey 12
LogMessage "Transaction closed"

LogMessage "=== Rework and Tool Type Check Completed ==="
CloseLogFile()
